/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.dialogs.OpenCorpusDialog;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.gui.components.NooJTableSorter;
import net.nooj4nlp.gui.dialogs.OpenCorpusDialog.AmbiguitiesUnambiguitiesDialog;
import net.nooj4nlp.gui.dialogs.OpenCorpusDialog.TokensDigramsDialog;

public class InversiveSortActionListener
extends MouseAdapter {
    private TokensDigramsDialog tokensDigramsDialog = null;
    private AmbiguitiesUnambiguitiesDialog ambigUnambigDialog = null;
    private boolean reversedSortingActive;
    private Language lan;

    public InversiveSortActionListener(TokensDigramsDialog tokensDigramsDialog, boolean reversedSortingActive, Language lan) {
        this.tokensDigramsDialog = tokensDigramsDialog;
        this.reversedSortingActive = reversedSortingActive;
        this.lan = lan;
    }

    public InversiveSortActionListener(AmbiguitiesUnambiguitiesDialog ambigUnambigDialog, boolean reversedSortingActive, Language lan) {
        this.ambigUnambigDialog = ambigUnambigDialog;
        this.reversedSortingActive = reversedSortingActive;
        this.lan = lan;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int i;
        JTable table = ((JTableHeader)e.getSource()).getTable();
        TableColumnModel colModel = table.getColumnModel();
        int index = colModel.getColumnIndexAtX(e.getX());
        DefaultTableModel tableModel = (DefaultTableModel)table.getModel();
        Vector<Vector> dataVector = tableModel.getDataVector();
        ArrayList<Vector> dataList = new ArrayList<Vector>(dataVector);
        ArrayList<Object[]> newDataList = new ArrayList<Object[]>();
        for (i = 0; i < dataList.size(); ++i) {
            Object[] tableRow = ((Vector)dataList.get(i)).toArray();
            newDataList.add(tableRow);
        }
        tableModel.getDataVector().removeAllElements();
        tableModel.fireTableDataChanged();
        if (index == 0) {
            Collections.sort(newDataList, new NooJTableSorter(0, this.reversedSortingActive, true, this.lan));
        } else if (this.tokensDigramsDialog != null) {
            Collections.sort(newDataList, new NooJTableSorter(1, this.reversedSortingActive, false, this.lan));
            this.tokensDigramsDialog.setReversedSortingActive(!this.reversedSortingActive);
        } else if (this.ambigUnambigDialog != null) {
            Collections.sort(newDataList, new NooJTableSorter(1, this.reversedSortingActive, false, this.lan));
            this.ambigUnambigDialog.setReversedSortingActive(!this.reversedSortingActive);
        }
        for (i = 0; i < newDataList.size(); ++i) {
            tableModel.addRow((Object[])newDataList.get(i));
        }
        table.setModel(tableModel);
        this.reversedSortingActive = !this.reversedSortingActive;
    }

    public void setTokensDigramsDialog(TokensDigramsDialog tokensDigramsDialog) {
        this.tokensDigramsDialog = tokensDigramsDialog;
    }

    public void setAmbigUnambigDialog(AmbiguitiesUnambiguitiesDialog ambigUnambigDialog) {
        this.ambigUnambigDialog = ambigUnambigDialog;
    }
}

